import java.util.ArrayList;
import java.util.LinkedList;

class HashingChaining<K, V> {
  // Interne Klasse fuer die Elemente in der Hashtabelle
  class Entry {
    K key;
    V value;
    public Entry(K key, V value) {
      this.key = key;
      this.value = value;
    }
  }

  // Die Groesse der Hashtabelle
  int size;
  // Die Hash-Tabelle besteht aus einer ArrayList von verketteten Listen
  ArrayList<LinkedList<Entry>> table;

  public HashingChaining(int size) {
    this.size = size;
    // Erzeuge alle verketteten Listen
    table = new ArrayList<LinkedList<Entry>>(size);
    for (int i = 0; i < size; i++) {
      table.add(i, new LinkedList<Entry>());
    }
  }

  void put(K key, V value) {
    // Berechne die Einfuegeposition
    int hashCode = key.hashCode() % size;
    Entry newEntry = new Entry(key, value);
    table.get(hashCode).add(newEntry);
  }

  V get(K key) {
    // Nehme die passende verkettete Liste fuer den Hashwert
    int hashCode = key.hashCode() % size;
    LinkedList<Entry> list = table.get(hashCode);

    // Suche in dieser Liste nach dem Element mit dem passenden Schluessel
    for (Entry element : list) {
      if (element.key.equals(key)) {
        return element.value; // Gefunden
      }
    }
    return null;  // Nicht gefunden
  }
  
  public String toString() {
    String result = "";
    int i = 0;
    for (LinkedList<Entry> list : table) {
      result += i++;
      for (Entry entry : list) {
        result += " -> " + entry.key + ", " + entry.value;
      }
      result += "\n";
    }
    return result;
  }

  public static void main(String[] args) {
    // Hashtabelle anlegen
    HashingChaining<String, Integer> hashtable = new HashingChaining<String, Integer>(16);
    // Werte einfuegen
    hashtable.put("ALL", 1);
    hashtable.put("YOUR", 2);
    hashtable.put("BASE", 3);
    hashtable.put("ARE", 4);
    hashtable.put("BELONG", 5);
    hashtable.put("TO", 6);
    hashtable.put("US", 7);
    // Hashtabelle anzeigen
    System.out.println(hashtable);
  }
}